/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.craftbukkit.v1_18_R2.CraftChunkSnapshot;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_18_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_18_R2.block.data.CraftBlockData;
import org.bukkit.entity.Entity;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.plugin.Plugin;

public class CraftChunk
implements Chunk {
    private WeakReference<LevelChunk> weakChunk;
    private final Level worldServer;
    private final int x;
    private final int z;
    private static final PalettedContainer<net.minecraft.world.level.block.state.BlockState> emptyBlockIDs = new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_);
    private static final byte[] emptyLight = new byte[2048];

    public CraftChunk(LevelChunk chunk) {
        this.weakChunk = new WeakReference<LevelChunk>(chunk);
        this.worldServer = this.getHandle().f_62776_;
        this.x = this.getHandle().m_7697_().f_45578_;
        this.z = this.getHandle().m_7697_().f_45579_;
    }

    public CraftChunk(ServerLevel worldServer, int x, int z) {
        this.weakChunk = new WeakReference<Object>(null);
        this.worldServer = worldServer;
        this.x = x;
        this.z = z;
    }

    @Override
    public World getWorld() {
        return this.worldServer.getWorld();
    }

    public CraftWorld getCraftWorld() {
        return (CraftWorld)this.getWorld();
    }

    public LevelChunk getHandle() {
        LevelChunk c = (LevelChunk)this.weakChunk.get();
        if (c == null) {
            c = this.worldServer.m_6325_(this.x, this.z);
            this.weakChunk = new WeakReference<LevelChunk>(c);
        }
        return c;
    }

    void breakLink() {
        this.weakChunk.clear();
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "CraftChunk{x=" + this.getX() + "z=" + this.getZ() + "}";
    }

    @Override
    public org.bukkit.block.Block getBlock(int x, int y, int z) {
        CraftChunk.validateChunkCoordinates(this.getHandle().m_141937_(), this.getHandle().m_151558_(), x, y, z);
        return new CraftBlock((LevelAccessor)this.worldServer, new BlockPos(this.x << 4 | x, y, this.z << 4 | z));
    }

    @Override
    public boolean isEntitiesLoaded() {
        return this.getCraftWorld().getHandle().f_143244_.m_157507_(ChunkPos.m_45589_((int)this.x, (int)this.z));
    }

    @Override
    public Entity[] getEntities() {
        long pair;
        PersistentEntitySectionManager entityManager;
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        if ((entityManager = this.getCraftWorld().getHandle().f_143244_).m_157507_(pair = ChunkPos.m_45589_((int)this.x, (int)this.z))) {
            return (Entity[])entityManager.getEntities(new ChunkPos(this.x, this.z)).stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).filter(Objects::nonNull).toArray(Entity[]::new);
        }
        entityManager.m_157555_(pair);
        ProcessorMailbox mailbox = ((EntityStorage)entityManager.f_157493_).f_182485_;
        BooleanSupplier supplier = () -> {
            if (entityManager.m_157507_(pair)) {
                return true;
            }
            if (!entityManager.isPending(pair)) {
                entityManager.m_157555_(pair);
            }
            entityManager.m_157506_();
            return entityManager.m_157507_(pair);
        };
        while (!supplier.getAsBoolean()) {
            if (mailbox.m_146355_() != 0) {
                mailbox.run();
                continue;
            }
            Thread.yield();
            LockSupport.parkNanos("waiting for entity loading", 100000L);
        }
        return (Entity[])entityManager.getEntities(new ChunkPos(this.x, this.z)).stream().map(net.minecraft.world.entity.Entity::getBukkitEntity).filter(Objects::nonNull).toArray(Entity[]::new);
    }

    @Override
    public BlockState[] getTileEntities() {
        if (!this.isLoaded()) {
            this.getWorld().getChunkAt(this.x, this.z);
        }
        int index = 0;
        LevelChunk chunk = this.getHandle();
        BlockState[] entities = new BlockState[chunk.f_187610_.size()];
        for (Object obj : chunk.f_187610_.keySet().toArray()) {
            if (!(obj instanceof BlockPos)) continue;
            BlockPos position = (BlockPos)obj;
            entities[index++] = this.worldServer.getWorld().getBlockAt(position.m_123341_(), position.m_123342_(), position.m_123343_()).getState();
        }
        return entities;
    }

    @Override
    public boolean isLoaded() {
        return this.getWorld().isChunkLoaded(this);
    }

    @Override
    public boolean load() {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), true);
    }

    @Override
    public boolean load(boolean generate) {
        return this.getWorld().loadChunk(this.getX(), this.getZ(), generate);
    }

    @Override
    public boolean unload() {
        return this.getWorld().unloadChunk(this.getX(), this.getZ());
    }

    @Override
    public boolean isSlimeChunk() {
        return WorldgenRandom.m_64685_((int)this.getX(), (int)this.getZ(), (long)this.getWorld().getSeed(), (long)this.worldServer.spigotConfig.slimeSeed).nextInt(10) == 0;
    }

    @Override
    public boolean unload(boolean save) {
        return this.getWorld().unloadChunk(this.getX(), this.getZ(), save);
    }

    @Override
    public boolean isForceLoaded() {
        return this.getWorld().isChunkForceLoaded(this.getX(), this.getZ());
    }

    @Override
    public void setForceLoaded(boolean forced) {
        this.getWorld().setChunkForceLoaded(this.getX(), this.getZ(), forced);
    }

    @Override
    public boolean addPluginChunkTicket(Plugin plugin) {
        return this.getWorld().addPluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    @Override
    public boolean removePluginChunkTicket(Plugin plugin) {
        return this.getWorld().removePluginChunkTicket(this.getX(), this.getZ(), plugin);
    }

    @Override
    public Collection<Plugin> getPluginChunkTickets() {
        return this.getWorld().getPluginChunkTickets(this.getX(), this.getZ());
    }

    @Override
    public long getInhabitedTime() {
        return this.getHandle().m_6319_();
    }

    @Override
    public void setInhabitedTime(long ticks) {
        Preconditions.checkArgument((ticks >= 0L ? 1 : 0) != 0, (Object)"ticks cannot be negative");
        this.getHandle().m_6141_(ticks);
    }

    @Override
    public boolean contains(BlockData block) {
        Preconditions.checkArgument((block != null ? 1 : 0) != 0, (Object)"Block cannot be null");
        com.google.common.base.Predicate nms = Predicates.equalTo((Object)((CraftBlockData)block).getState());
        for (LevelChunkSection section : this.getHandle().m_7103_()) {
            if (section == null || !section.m_63019_().m_63109_((Predicate)nms)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ChunkSnapshot getChunkSnapshot() {
        return this.getChunkSnapshot(true, false, false);
    }

    @Override
    public ChunkSnapshot getChunkSnapshot(boolean includeMaxBlockY, boolean includeBiome, boolean includeBiomeTempRain) {
        LevelChunk chunk = this.getHandle();
        LevelChunkSection[] cs = chunk.m_7103_();
        PalettedContainer[] sectionBlockIDs = new PalettedContainer[cs.length];
        byte[][] sectionSkyLights = new byte[cs.length][];
        byte[][] sectionEmitLights = new byte[cs.length][];
        boolean[] sectionEmpty = new boolean[cs.length];
        PalettedContainer[] biome = includeBiome || includeBiomeTempRain ? new PalettedContainer[cs.length] : null;
        Registry iregistry = this.worldServer.m_5962_().m_175515_(Registry.f_122885_);
        Codec biomeCodec = PalettedContainer.m_188054_((IdMap)iregistry.m_206115_(), (Codec)iregistry.m_206110_(), (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188138_, (Object)iregistry.m_206081_(Biomes.f_48202_));
        for (int i = 0; i < cs.length; ++i) {
            CompoundTag data = new CompoundTag();
            data.m_128365_("block_states", (Tag)ChunkSerializer.f_188227_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)cs[i].m_63019_()).get().left().get());
            sectionBlockIDs[i] = (PalettedContainer)ChunkSerializer.f_188227_.parse((DynamicOps)NbtOps.f_128958_, (Object)data.m_128469_("block_states")).get().left().get();
            LevelLightEngine lightengine = chunk.f_62776_.m_5518_();
            DataLayer skyLightArray = lightengine.m_75814_(LightLayer.SKY).m_8079_(SectionPos.m_123173_((int)this.x, (int)i, (int)this.z));
            if (skyLightArray == null) {
                sectionSkyLights[i] = emptyLight;
            } else {
                sectionSkyLights[i] = new byte[2048];
                System.arraycopy(skyLightArray.m_7877_(), 0, sectionSkyLights[i], 0, 2048);
            }
            DataLayer emitLightArray = lightengine.m_75814_(LightLayer.BLOCK).m_8079_(SectionPos.m_123173_((int)this.x, (int)i, (int)this.z));
            if (emitLightArray == null) {
                sectionEmitLights[i] = emptyLight;
            } else {
                sectionEmitLights[i] = new byte[2048];
                System.arraycopy(emitLightArray.m_7877_(), 0, sectionEmitLights[i], 0, 2048);
            }
            if (biome == null) continue;
            data.m_128365_("biomes", (Tag)biomeCodec.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)cs[i].m_188013_()).get().left().get());
            biome[i] = (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)data.m_128469_("biomes")).get().left().get();
        }
        Heightmap hmap = null;
        if (includeMaxBlockY) {
            hmap = new Heightmap((ChunkAccess)chunk, Heightmap.Types.MOTION_BLOCKING);
            hmap.m_158364_((ChunkAccess)chunk, Heightmap.Types.MOTION_BLOCKING, ((Heightmap)chunk.f_187608_.get(Heightmap.Types.MOTION_BLOCKING)).m_64239_());
        }
        World world = this.getWorld();
        return new CraftChunkSnapshot(this.getX(), this.getZ(), chunk.m_141937_(), chunk.m_151558_(), world.getName(), world.getFullTime(), sectionBlockIDs, sectionSkyLights, sectionEmitLights, sectionEmpty, hmap, (Registry<Biome>)iregistry, biome);
    }

    @Override
    public PersistentDataContainer getPersistentDataContainer() {
        return this.getHandle().persistentDataContainer;
    }

    public static ChunkSnapshot getEmptyChunkSnapshot(int x, int z, CraftWorld world, boolean includeBiome, boolean includeBiomeTempRain) {
        ChunkAccess actual = world.getHandle().m_46819_(x, z, ChunkStatus.f_62314_);
        int hSection = actual.m_151559_();
        PalettedContainer[] blockIDs = new PalettedContainer[hSection];
        byte[][] skyLight = new byte[hSection][];
        byte[][] emitLight = new byte[hSection][];
        boolean[] empty = new boolean[hSection];
        Registry iregistry = world.getHandle().m_5962_().m_175515_(Registry.f_122885_);
        PalettedContainer[] biome = includeBiome || includeBiomeTempRain ? new PalettedContainer[hSection] : null;
        for (int i = 0; i < hSection; ++i) {
            blockIDs[i] = emptyBlockIDs;
            skyLight[i] = emptyLight;
            emitLight[i] = emptyLight;
            empty[i] = true;
            if (biome == null) continue;
            biome[i] = new PalettedContainer(iregistry.m_206115_(), (Object)iregistry.m_206081_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_);
        }
        return new CraftChunkSnapshot(x, z, world.getMinHeight(), world.getMaxHeight(), world.getName(), world.getFullTime(), blockIDs, skyLight, emitLight, empty, new Heightmap(actual, Heightmap.Types.MOTION_BLOCKING), (Registry<Biome>)iregistry, biome);
    }

    static void validateChunkCoordinates(int minY, int maxY, int x, int y, int z) {
        Preconditions.checkArgument((0 <= x && x <= 15 ? 1 : 0) != 0, (String)"x out of range (expected 0-15, got %s)", (int)x);
        Preconditions.checkArgument((minY <= y && y <= maxY ? 1 : 0) != 0, (String)"y out of range (expected %s-%s, got %s)", (Object)minY, (Object)maxY, (Object)y);
        Preconditions.checkArgument((0 <= z && z <= 15 ? 1 : 0) != 0, (String)"z out of range (expected 0-15, got %s)", (int)z);
    }

    static {
        Arrays.fill(emptyLight, (byte)-1);
    }
}

